// Mapeo de clases para el estado de scroll
var classMapping = {
    'navbar-mgg': 'navbar-8qo',
    'sup-3wv': 'sup-cyg',
    'rel-tmi': 'rel-a9d',
    'ani-3os': 'ani-y3m',
    'visible-lyq': 'visible-fnx',
    'ali-so7': 'ali-ap3',
    'list-smm': 'list-x9y',
    'sep-lyk': 'sep-p8m',
    'cen-2lo': 'cen-k84',
    'block-6px': 'block-4qs',
    'header-ti3': 'header-vdz',
    'navbar-sef': 'navbar-1fc',
    'toggle-yom': 'toggle-da4',
    'sr-rox': 'sr-yok',
    'icon-3cv': 'icon-p18',
    'navbar-brand-l5r': 'navbar-brand-fkc',
    'hidden-gsa': 'hidden-gq7',
    'col-1g5': 'col-h44',
    'navbar-collapse-3mk': 'navbar-collapse-996',
    'nav-xmp': 'nav-c8j',
    'navbar-nav-fam': 'navbar-nav-dqb',
    'dro-dz6': 'dro-ip7',
    'dropdown-co6': 'dropdown-15p',
    'hover-feo': 'hover-zt4',
    'text-nly': 'text-21n',
    'fa-tck': 'fa-21n',
    'fa-a3b': 'fa-1kp',
    'dropdown-menu-1fn': 'dropdown-menu-ewp',
    'logo-vdp': 'logo-obr',
    'form-y77': 'form-4wd'
};

// Función para cambiar clases en el navbar
function changeNavbarClasses(scrolled) {
    var navbar = document.querySelector('nav');
    if (!navbar) return;

    // Cambiar la clase del navbar principal primero
    if (scrolled) {
        if (navbar.classList.contains('navbar-mgg')) {
            navbar.classList.remove('navbar-mgg');
            navbar.classList.add('navbar-8qo');
        }
    } else {
        if (navbar.classList.contains('navbar-8qo')) {
            navbar.classList.remove('navbar-8qo');
            navbar.classList.add('navbar-mgg');
        }
    }

    // Cambiar todas las clases según el estado de scroll
    for (var oldClass in classMapping) {
        var newClass = classMapping[oldClass];
        // Buscar elementos con la clase antigua o nueva
        var selector = scrolled ? '.' + oldClass : '.' + newClass;
        var elements = navbar.querySelectorAll(selector);
        
        elements.forEach(function(element) {
            if (scrolled) {
                // Cambiar de clase antigua a nueva
                if (element.classList.contains(oldClass)) {
                    element.classList.remove(oldClass);
                    element.classList.add(newClass);
                }
            } else {
                // Cambiar de clase nueva a antigua
                if (element.classList.contains(newClass)) {
                    element.classList.remove(newClass);
                    element.classList.add(oldClass);
                }
            }
        });
    }
}

// Toggle del menú móvil del navbar
document.addEventListener('DOMContentLoaded', function() {
    // Detectar scroll y cambiar clases
    var lastScrollTop = 0;
    var scrollThreshold = 50; // Píxeles de scroll antes de cambiar
    
    window.addEventListener('scroll', function() {
        var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        var isScrolled = scrollTop > scrollThreshold;
        
        if (isScrolled !== (lastScrollTop > scrollThreshold)) {
            changeNavbarClasses(isScrolled);
        }
        
        lastScrollTop = scrollTop;
    }, false);
    
    // Inicializar estado según scroll actual
    var initialScroll = window.pageYOffset || document.documentElement.scrollTop;
    if (initialScroll > scrollThreshold) {
        changeNavbarClasses(true);
    }
    // Toggle del menú móvil lateral (buscar con ambas clases posibles)
    var toggleButton = document.querySelector('.toggle-yom, .toggle-da4');
    var navbarCollapse = document.querySelector('.navbar-collapse-3mk, .navbar-collapse-996');
    var wrapperMenu = document.querySelector('.wrapper-gqi');
    
    if (toggleButton && wrapperMenu) {
        toggleButton.addEventListener('click', function() {
            // Toggle del menú lateral usando clases para animación CSS
            if (wrapperMenu.classList.contains('menu-abierto')) {
                // Cerrar con animación
                wrapperMenu.classList.remove('menu-abierto');
                // Ocultar completamente después de la animación
                setTimeout(function() {
                    if (!wrapperMenu.classList.contains('menu-abierto')) {
                        wrapperMenu.style.display = 'none';
                    }
                }, 300);
            } else {
                // Abrir con animación - primero mostrar, luego animar
                wrapperMenu.style.display = 'block';
                // Pequeño delay para que el display se aplique antes de la animación
                setTimeout(function() {
                    wrapperMenu.classList.add('menu-abierto');
                }, 10);
            }
            
            // También toggle del navbar collapse si existe
           
        });
    }
    
    // Cerrar menú lateral al hacer click fuera
    document.addEventListener('click', function(event) {
        if (wrapperMenu && !wrapperMenu.contains(event.target) && toggleButton && !toggleButton.contains(event.target)) {
            if (window.innerWidth <= 1200 && wrapperMenu.classList.contains('menu-abierto')) {
                wrapperMenu.classList.remove('menu-abierto');
                // Ocultar completamente después de la animación
                setTimeout(function() {
                    if (!wrapperMenu.classList.contains('menu-abierto')) {
                        wrapperMenu.style.display = 'none';
                    }
                }, 300);
            }
        }
    });
    
    // Cerrar dropdowns al hacer click fuera (buscar con ambas clases posibles)
    document.addEventListener('click', function(event) {
        var dropdowns = document.querySelectorAll('.dropdown-co6, .dropdown-15p, .dropdown-npa');
        dropdowns.forEach(function(dropdown) {
            var menu = dropdown.querySelector('.dropdown-menu-1fn, .dropdown-menu-ewp, .dropdown-menu-fzl');
            if (menu && !dropdown.contains(event.target)) {
                menu.style.display = 'none';
            }
        });
    });
    
    // Toggle de dropdowns del navbar principal (buscar con ambas clases posibles)
    var dropdownToggles = document.querySelectorAll('.dropdown-co6 > a, .dropdown-15p > a');
    dropdownToggles.forEach(function(toggle) {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            var menu = this.nextElementSibling;
            if (menu && (menu.classList.contains('dropdown-menu-1fn') || menu.classList.contains('dropdown-menu-ewp'))) {
                var isVisible = menu.style.display === 'block';
                // Cerrar todos los dropdowns del navbar
                document.querySelectorAll('.dropdown-menu-1fn, .dropdown-menu-ewp').forEach(function(m) {
                    m.style.display = 'none';
                });
                // Abrir el clickeado si estaba cerrado
                if (!isVisible) {
                    menu.style.display = 'block';
                }
            }
        });
    });
    
    // Toggle de dropdowns del menú lateral móvil
    var sidebarDropdownToggles = document.querySelectorAll('.sidebar-pc6 .dropdown-npa > a');
    sidebarDropdownToggles.forEach(function(toggle) {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            var menu = this.nextElementSibling;
            if (menu && menu.classList.contains('dropdown-menu-fzl')) {
                var isVisible = menu.style.display === 'block' || menu.style.display === '';
                // Cerrar todos los dropdowns del sidebar
                document.querySelectorAll('.sidebar-pc6 .dropdown-menu-fzl').forEach(function(m) {
                    m.style.display = 'none';
                });
                // Abrir el clickeado si estaba cerrado
                if (!isVisible) {
                    menu.style.display = 'block';
                }
            }
        });
    });
});
