// Slider de testimonios
document.addEventListener('DOMContentLoaded', function() {
    var currentSlide = 0;
    var slideContainer = document.getElementById('style-kxMoI');
    var slides = document.querySelectorAll('.testi-7bv');
    var prevButton = document.querySelector('.fa-dm2').closest('a');
    var nextButton = document.querySelector('.fa-ngp').closest('a');
    var totalSlides = slides.length;
    
    // Función para calcular el ancho del slide según el tamaño de pantalla
    function getSlideWidth() {
        if (slides.length === 0) return 600;
        
        // Obtener el ancho real del primer slide
        var firstSlide = slides[0];
        var slideRect = firstSlide.getBoundingClientRect();
        var slideWidth = slideRect.width;
        
        // Obtener el margin-right del slide
        var slideStyle = window.getComputedStyle(firstSlide);
        var marginRight = parseFloat(slideStyle.marginRight) || 0;
        
        // Retornar ancho total (ancho del elemento + margen derecho)
        return slideWidth + marginRight;
    }
    
    // Función para mover el slider
    function moveSlider(direction) {
        if (direction === 'next') {
            currentSlide = (currentSlide + 1) % totalSlides;
        } else if (direction === 'prev') {
            currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
        }
        
        var slideWidth = getSlideWidth();
        var translateX = -(currentSlide * slideWidth);
        slideContainer.style.transform = 'translate3d(' + translateX + 'px, 0px, 0px)';
        slideContainer.style.transitionDuration = '0.5s';
    }
    
    // Inicializar posición del slider al cargar
    function initializeSlider() {
        var slideWidth = getSlideWidth();
        slideContainer.style.transform = 'translate3d(0px, 0px, 0px)';
        slideContainer.style.transitionDuration = '0s';
        currentSlide = 0;
        // Activar transiciones después de un breve delay
        setTimeout(function() {
            slideContainer.style.transitionDuration = '0.5s';
        }, 100);
    }
    
    // Inicializar al cargar
    initializeSlider();
    
    // Recalcular al redimensionar la ventana
    window.addEventListener('resize', function() {
        var slideWidth = getSlideWidth();
        var translateX = -(currentSlide * slideWidth);
        slideContainer.style.transform = 'translate3d(' + translateX + 'px, 0px, 0px)';
    });
    
    // Event listeners para los botones
    if (nextButton) {
        nextButton.addEventListener('click', function(e) {
            e.preventDefault();
            moveSlider('next');
        });
    }
    
    if (prevButton) {
        prevButton.addEventListener('click', function(e) {
            e.preventDefault();
            moveSlider('prev');
        });
    }
    
    // Modales
    var modalButtons = document.querySelectorAll('.btn-q5s');
    var modals = document.querySelectorAll('.modal-itq');
    var closeButtons = document.querySelectorAll('.clo-yq8');
    
    // Abrir modal
    modalButtons.forEach(function(button, index) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            if (modals[index]) {
                modals[index].style.display = 'block';
                setTimeout(function() {
                    modals[index].classList.remove('fa-oye');
                }, 10);
            }
        });
    });
    
    // Cerrar modal
    closeButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            var modal = this.closest('.modal-itq');
            if (modal) {
                modal.classList.add('fa-oye');
                setTimeout(function() {
                    modal.style.display = 'none';
                }, 150);
            }
        });
    });
    
    // Cerrar modal al hacer click fuera
    modals.forEach(function(modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) {
                modal.classList.add('fa-oye');
                setTimeout(function() {
                    modal.style.display = 'none';
                }, 150);
            }
        });
    });
});
